<?php
namespace Import\ApiBundle\Services\Api;


class ApiBasicMethods
{
    /**
     * @var \Symfony\Component\DependencyInjection\Container
     */
    protected $Container;

    protected $errors = array();

    protected $printPercent_id = 0;
    protected $printPercent_count = 0;

    public function __construct(\Symfony\Component\DependencyInjection\Container $Container)
    {
        $this->Container = $Container;
    }

    protected function get($service)
    {
        return $this->Container->get($service);
    }

    protected function getDoctrine()
    {
        return $this->Container->get('doctrine');
    }

    protected function viewErrors()
    {
        if(!empty($this->errors))
        {
            print_r($this->errors);
        }
    }

    protected function printPercent($id = null,$count = null)
    {
        if(is_null($id))
        {
            $id = $this->printPercent_id;
            $this->printPercent_id++;
        }
        if(is_null($count))
        {
            $count = $this->printPercent_count;
        }
        $value = (float)$id/$count*100;
        if($id > 0) echo chr(8).chr(8).chr(8).chr(8).chr(8).chr(8);
        if($value < 10) echo '  '; elseif($value < 100) echo ' ';
        echo sprintf("%3.1f", $value).'%';
    }
}
